/**
* \file: AditCoreSurrogate.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* Proxy for Baidu core, initializes and deinitializes connection.
*
* \component: Baidu CarLife
*
* \author: P. Acar / ADIT/SW2 / pacar@de.adit-jv.com
*
* \copyright (c) 2017 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#ifndef BDCL_ADITCORESURROGATE_H
#define BDCL_ADITCORESURROGATE_H

#include <memory>
#include <bdcl/CCarLifeLib.h>
#include <bdcl/bdclErrorCodes.h>
#include <bdcl/AditBaiduCore.h>
#include "BaiduCoreCallbackDealer.h"

namespace adit { namespace bdcl {

class abdcl;

class AditCoreSurrogate
{
public:
    AditCoreSurrogate(IAditBaiduCoreCallbacks* inCallbacks, CoreCallbackDealer* inCallbackDealer);
    ~AditCoreSurrogate();

    // todo const
    bdclInitStatus initialize(int aoapAccessoryId, int aoapDeviceId);
    bdclInitStatus initialize(const char* wFile, const char* rFile);

    void abortInitialization();

    void teardown();

    void setProtocolStatusTimeout(uint16_t inTimeout);
    void setCarLifeStaticsInfo(S_STATISTICS_INFO* inInfo);

private:
    std::unique_ptr<abdcl> mBackend;

};

} } /* namespace adit { namespace bdcl { */

#endif /* BDCL_ADITCORESURROGATE_H */
